<!--
;
; BaudTec Corporation
;
; --------------------------------------------------------------------------------
; Rev   Name    Date    Description
; --------------------------------------------------------------------------------
; R00   BAU-MCL 140418  Initial version.
; R01   BAU-RTK 140418  [Feature Enhancement]
;                       Realtek provides patch 140416_patch_flexport.rar .
;                       It is from Hill's e-mail 2014-04-17 07:23 PM.
;
;                       Add flexport feature depend on DHCP option 60.
-->
<html>
<! Copyright (c) Realtek Semiconductor Corp., 2003. All Rights Reserved. ->
<head>
<meta http-equiv="Content-Type" content="text/html" charset="utf-8">
<title>STB IP Pool</title>
<script type="text/javascript" src="share.js">
</script>
<SCRIPT>

function checkInputIP(ip)
{
	var i, ip_d;
	for (i=1; i<5; i++) {
		ip_d = getDigit(ip, i);
	}
	if ((ip_d >= parseInt(document.dhcpd.dhcpRangeStart.value, 10)) && (ip_d <= parseInt(document.dhcpd.dhcpRangeEnd.value, 10))) {
		return false;
	}
	return true;
}

function checkSubnet(ip, mask, client)
{
  ip_d = getDigit(ip, 4);
  mask_d = getDigit(mask, 4);
  if ( (ip_d & mask_d) != (client & mask_d ) )
	return false;

  return true;
}

function checkDigitRange_leaseTime(str, min)
{
  d = parseInt(str, 10);
  if ( d < min || d == 0)
      	return false;
  return true;
}

function validateKey_leasetime(str)
{
   for (var i=0; i<str.length; i++) {
    if ( (str.charAt(i) >= '0' && str.charAt(i) <= '9') ||
    		(str.charAt(i) == '-' ) )
			continue;
	return 0;
  }
  return 1;
}


function saveChanges()
{
	if ( includeSpace(document.dhcpd.dname.value)) {
		alert('Invalid domain name.');
		document.dhcpd.dname.focus();
		return false;
 	}
	if (checkString(document.dhcpd.dname.value) == 0) {
		alert('Invalid domain name.');
		document.dhcpd.dname.focus();
		return false;
	}
	
	if (!checkHostIP(document.dhcpd.dhcpRangeStart, 1)) {
		document.dhcpd.dhcpRangeStart.value = document.dhcpd.dhcpRangeStart.defaultValue;
		alert('Invalid dhcpRangeStart IP.');
		document.dhcpd.dhcpRangeStart.focus();
		return false;
	}
	if (!checkHostIP(document.dhcpd.dhcpRangeEnd, 1)) {
		document.dhcpd.dhcpRangeEnd.value = document.dhcpd.dhcpRangeEnd.defaultValue;
		alert('Invalid dhcpRangeEnd IP.');
		document.dhcpd.dhcpRangeEnd.focus();
		return false;
	}
	
	if ( document.dhcpd.ltime.value=="") {
		alert("Please input dhcp lease time.");
		document.dhcpd.ltime.focus();
		return false;
	}
	if ( validateKey_leasetime( document.dhcpd.ltime.value ) == 0 ) {
		alert("Invalid DHCP Server lease time number.");
		document.dhcpd.ltime.value = document.dhcpd.ltime.defaultValue;
		document.dhcpd.ltime.focus();
		return false;
	}
	if ( !checkDigitRange_leaseTime(document.dhcpd.ltime.value, -1) ) {
	  	alert('Invalid DHCP Server lease time.');
		document.dhcpd.ltime.value = document.dhcpd.ltime.defaultValue;
		document.dhcpd.ltime.focus();
		return false;
	}
	if (!checkHostIP(document.dhcpd.ip, 1)) {
		alert('Invalid Gateway IP.');
		return false;
	}
	return true;		
}
</SCRIPT>
</head>


<body>
<blockquote>
<h2><font color="#0000FF">STB Data IP Pool Assignment</font></h2>

<table border=0 width="480" cellspacing=0 cellpadding=0>
  <tr><td><font color="#00FFFF" size=2>
 This page is used to configure the IP Pool for STB. Please note that the STB IP domain is different from default IP Pool.
  </font></td></tr>
  <tr><td><hr size=1 noshade align=top></td></tr>
</table>

<!--<form action=/boaform/formStbIp method=POST name="stbIp">-->
<form action="stbDataIptbl.asp" method="post" name="stbIp">

	<table border=0 width="500" cellspacing=4 cellpadding=0>
		<tr>
			<td width="30%"><font size=2><b>IP Pool Range:</b></td>
			<td width="70%"><input type="text" name="dhcpRangeStart" size=15 maxlength=15 value="">
				<font face="Arial" size="5">- <input type="text" name="dhcpRangeEnd" size=15 maxlength=15 value="">&nbsp;
			</td>
		</tr>
		
		<tr>
			<td width="30%"><font size=2><b>Subnet Mask:</b></td>
			<td width="70%"><font size=2>
				<input type="text" name="dhcpSubnetMask" size=15 maxlength=15 value="">&nbsp;
			</td>
		</tr>
		
		<tr>
			<td width="30%"><font size=2><b>Max Lease Time:</b></td>
			<td width="70%"><font size=2>
				<input type="text" name="ltime" size=10 maxlength=9 value=""><b> seconds</b><b> (-1 indicates an infinite lease)</b>
			</td>
		</tr>
		<tr>
			<td width="30%"><font size=2><b>Domain Name:</b></td>
			<td width="70%">
			<input type="text" name="dname" size=32 maxlength=29 value="">
			</td>
		</tr>
		<tr>
			<td width="30%"><font size=2><b>Gateway Address:</b></td>
			<td width="70%"><input type="text" name="ip" size="15" maxlength="15" value=></td>
		</tr>
		<!-- R01
		<tr>
			<td width="30%"><font size=2><b>< % multilang("option 60(Network)"); % >:</b></td>
			<td width="70%">
			<input type="text" name="opt60name1" size=32 maxlength=29 value="< % getInfo("lan-dhcpSTBNOpt60"); % >">
			</td>
		</tr>
		<tr>
			<td width="30%"><font size=2><b>< % multilang("option 60(Local)"); % >:</b></td>
			<td width="70%">
			<input type="text" name="opt60name2" size=32 maxlength=29 value="< % getInfo("lan-dhcpSTBLOpt60"); % >">
			</td>
		</tr>
		-->
	</table>
	
	<input type="submit" value="Apply Changes" name="save" onClick="return saveChanges()">&nbsp;&nbsp;
	<input type="hidden" value="/stbDataIptbl.asp" name="submit-url">
	<input type="button" value="Close" name="close" onClick="javascript: window.close();">

<script>
	
</script>

</form>
</blockquote>
</body>

</html>
